	;*******************************
	;*                             *
	;*         POLY-SPLIT          *
	;*                             *
	;*  A PROGRAM FOR POLYPHONIC   *
	;*      SPLIT KEYBOARD         *				
	;*                             *
	;*            BY               *				
	;*      JOHN SIMONTON          *				
	;*                             *
	;* (C) 1979 - PAIA ELECTRONICS *				
	;*                             *
	;*******************************
	
KTBL	=$00E0
NTBL	=$00D8
HKEY	=$00A2
SPLT	=$00A1
OUT2	=$00EC
OUTT	=$00EB
OUTS	=$00EA
trgn	=$0DC3	;MUS-1 unused	
INIT	=$0D21	;MUS-1
NOTE	=$0D2B	;MUS-1
POLY	=$0D71	;MUS-1
DECD	=$0F00	;PIEBUG
	;
	;FIRST, SYSTEM THINGS ARE DISPOSED OF.  THE SYSTEM IS
	;INITIALIZED USING MUS 1.0'S "INIT" ROUTINE, THEN THE
	;QUASH CHANNELS ARE REFRESHED AND THE AGO KEYBOARD
	;SCANNED ALSO USING ROUTINES FROM MUS 1.0
	;FINNALLY, THE PIEBUG ROUTINE "DECODE" IS USED TO READ THE
	;COMMAND KEYBOARD AND ANY COMMANDS ARE EXECUTED.
	;0-SYSTEM CLEAR AND RE-INIT; 1-TUNE ALL CHANNELS;
	;2-SET SPLIT POINT, AND AGO KEY PRESSES BECOMES SPLIT
	;
		org	$0000
	;
STAR:
	lda	OUTT	;GET THE # OF RESERVED LOW CHANS
	sta	OUT2	;SAVE PERMANENTLY
POSP:
	ldx	#$07	;SET UP A POINTER/COUNTER
SLP9:
	lda	#$00	;AND GET READY TO ZERO STUFF
	sta	HKEY,x	;ZERO THE TEMPORARY BUFFER
	dex		;AND POINT TO THE NEXT
	bpl	SLP9	;IF SOME ARE LEFT, LOOP
	jsr	INIT	;MUS 1.0 - INITIALIZE SYSTEM
SLP6:
	jsr	NOTE	;MUS 1.0 - REFRESH AND READ AGO KBD
	jsr	DECD	;PIEBUG - READ COMMAND KEYBOARD
	beq	POSP	;IF COMMAND = 0, BRANCH TO RE-INIT
	cmp	#$01	;IS COMMAND = 1?
	bne	NTST	;NO, BRANCH TO NEXT TEST
	lda	#$2E	;WILL BECOME MIDDLE C
	jsr	INIT+2	;USE PART OF MUS 1.0 INITIALIZE
	beq	SLP6	;BRANCH ALWAYS
NTST:
	cmp	#$02	;IS COMMAND = 2?
	bne	SPLI	;NO, BRANCH TO POLY-SPLIT PROGRAM
	lda	KTBL+7	;GET THE LOWEST KEY DOWN
	beq	SLP6	;IF NONE ARE DOWN, LOOP
	sta	SPLT	;SAVE THE KEY AS THE SPLIT POINT
	bne	SLP6	;BRANCH ALWAYS
	;
	;NOW THE SPLIT PROGRAM. AT THIS POINT A LIST OF THE
	;AGO KEYS WHICH THE MUS 1.0 SUBROUTINE "LOOK" FOUND TO
	;BE PRESSED HAS BEEN COMPILED AND SAVED IN THE INPUT BUFFER
	;AREA "KTBL".  WE BEGIN BY REMOVING FROM THE INPUT BUFFER
	;ALL THOSE KEYS WHICH ARE ABOVE THE SPLIT POINT AND
	;TRANSFERING THEM TO THE TEMPORARY BUFFER AREA "HKEY"
	;
SPLI:
	ldy	#$07	;SET UP POINTER TO HIGH BUFFER
	ldx	#$07	;AND ONE TO INPUT BY
SLP0:
	lda	KTBL,x	;GET THE KEY
	beq	SNX1	;IF ZERO, GO TO NEXT
	cmp	SPLT	;GREATER THAN SPLIT POINT?
	bcc	SNX0	;IF NOT GREATER, BRANCH
	sta	HKEY,y	;GREATER, SAVE IN HIGH BUFFER
	dey		;POINT TO NEXT HIGH KEY BUFFER
	lda	#$00	;PREPARE AND
	sta	KTBL,x	;ZERO THIS KEY
SNX0:
	dex		;POINT TO NEXT KEY
	bpl	SLP0	;IF SOME LEFT, LOOP
	;
	;NEXT THE NUMBER OF CHANNELS AVAILABLE FOR LOW KEY USE
	;IS TRANSFERED TO THE TEMPORARY COUNTER "OUTT" AND THE
	;MUS 1.0 ALLOCATION PROGRAM POLY IS CALLED TO ASSIGN LOW
	;KEYS TO LOW CHANNELS
	;
SNX1:
	lda	OUT2	;GET THE NUMBER OF LOW CHANS AVAILABLE
	sta	OUTT	;AND PUT IT IN THE TEMPORARY COUNTER
	jsr	POLY+4	;AND CALL THE MAIN PORTION OF POLY
	;
	;NOW THAT THE LOW KEYS HAVE BEEN ALLOCATED TO LOW CHANNELS,
	;THE HIGH KEYS ARE TAKEN FROM "HKEY" AND PLACED BACK IN THE
	;INPUT BUFFER (KEYS ALREADY ALLOCATED ARE REMOVED FROM THE
	;INPUT BUFFER). SIMULTANEOUSLY THE LOW CHANNELS ARE MOVED
	;TO HKEY AND ALL LOW CHANNELS IN THE OUTPUT BUFFER
	;ARE MARKED AS "IN USE" SO THAT THEY WILL BE IGNORED
	;WHEN HIGH KEYS ARE ALLOCATED.
	;
	ldy	OUT2	;A COUNTER TO MOVE ONLY THE LOW CHANNELS
	ldx	#$07	;AND A POINTER/COUNTER
SPL1:
	lda	HKEY,x	;GET THE HIGH KEY FROM TEMP BUFFER
	sta	KTBL,x	;PUT IT IN THE INPUT BUFFER
	dey		;ONE LESS LOW CHANNEL  TO DO
	bmi	SNX2	;ALL LOW CHANNELS DONE, BRANCH
	lda	NTBL,x	;GET THE LOW NOTE
	sta	HKEY,x	;PUT IT IN TEMPORARY BUFFER
	ora	#$40	;THEN SET THE TRIGGER TO MARK NOTE
	sta	NTBL,x	;AND REPLACE THE NOTE
SNX2:
	dex		;ONE LESS CHANNEL, POINT TO NEXT
	bpl	SPL1	;IF SOME LEFT, LOOP
	;
	;NOW POLY IS CALLED AGAIN, THIS TIME TO ALLOCATE HIGH CHANNELS
	;
	sec		;PREPARE FOR SUBTRACTION
	lda	#$10	;16 CHANNELS SUPPORTED BY MUS1
	sbc	OUT2	;LESS THE LOW RESERVED CHANNELS
	tax		;RESULT IS POINTER
	sec		;ANOTHER SUBTRACTION - PREPARE
	lda	OUTS	;TOTAL HARDWARE CHANNELS
	sbc	OUT2	;LESS LOW RESERVED CHANNELS
	sta	OUTT	;BECOMES CHANNELS LEFT TO ALLOCATE
	jsr	POLY+6	;CALL MAJOR PORTION OF POLY
	;
	;FINALLY, THE REAL STATE OF THE LOW CHANNELS IS RESPORED
	;TO THE OUTPUT BUFFER. SIMULTANEOUSLY THE TEMPORARY BUFFER
	;IS ZERO'D FOR THE NEXT PASS.
	;
	ldy	OUT2	;NUMBER OF LOW CHANNELS FOR COUNTER
	ldx	#$07	;POINTER/COUNTER
SLP2:
	dey		;ONE LESS LOW CHANNEL
	bmi	SNX3	;AND IF ALL DONE, SKIP NEXT TRANSFER
 REAL CHANNEL STATE
	sta	NTBL,x	;PLACE IN OUTPUT BUFFER
SNX3:
	lda	#$00	;NOW GET READY AND
	sta	HKEY,x	;ZERO THIS TEMPORARY BUFFER LOCATION
	dex		;ONE LESS TEMP BUFFER LOCATION
	bpl	SLP2	;IF SOME REMAIN. LOOP
	bmi	SLP6	;BRANCH ALWAYS TO CONTINUE
	
	;*******************************
	;*            NOTES:            *
	;*  DUMP PROGRAM FROM 0000-0090 *
	;*                              *
	;*  SET THESE LOCATION:         *
	;*                              *
	;*     $0E8 CTRL $40 DYNAMIC    *
	;*     $0E9 ODLY $20 DELAY      *
	;*     $0EA OUTS $XX TOT CHANS  *
	;*     $0EB OUTT $XX LOW CHANS  *
	;*                              *
	;*  COLD START - $0000          *
	;*  WARM START = $0004          *
	;*                              *
	;*  NOTE THE FOLLOWING THINGS:  *
	;*                              *
	;*1) THE PROGRAM IS RELOCATABLE;*
	;*   IT MAY BE LOADED AND RUN IN*
	;*   ANY NON-CONFLICTING MEMRORY*
	;*   SPACE                      *
	;*                              *
	;*2) CALLING POLY TWICE IS NOT  *
	;*   EXTRA EFFICIENT.  TIME RE- *
	;*   QUIREMENTS DICTATE MEDIUM  *
	;*   TEMP KNOB SETTING - ABOUT  *
	;*   10 MS/SCAN                 *
	;*                              *
	;*3) AS SOON AS THE PROGRAM IS  *
	;*   RUNNING, TOUCH COMMAND PAD *
	;*   2 AND THE KEY WHICH IS TO  *
	;*   BE THE SPLIT POINT. THEN 1 *
	;*   TO TUNE AND FINALLY 0      *
	;*   BEFORE PLAYING             *
	;*                              *
	;********************************
	;POLY-SPLIT 8.8
		